//
//  File.swift
//  EcoWarriors
//
//  Created by Ria on 14/08/19.
//  Copyright © 2019 Ria. All rights reserved.
//

import UIKit

class CPController: UIViewController{
    
    //MARK:- viewDidLoad()
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        setupScrollView()
        pageSetup()

    }
    
    //MARK:- Page Setup
    
    func pageSetup() {
        
        //MARK:- Navigation Bar
        
        self.navigationItem.title = "Completed projects"
        navigationController?.navigationBar.barTintColor = .mainBlue()
        navigationController?.navigationBar.barStyle = .black
        navigationItem.leftBarButtonItem = UIBarButtonItem(image: #imageLiteral(resourceName: "Cross").withRenderingMode(.alwaysOriginal), style: .plain, target: self, action: #selector(handleDismiss))
        navigationItem.rightBarButtonItem = UIBarButtonItem(image:#imageLiteral(resourceName: "logo1").withRenderingMode(.alwaysOriginal), style: .plain , target: self, action: #selector(doNothing))
    
        //MARK:- Project 1
        
        let P1Image = UIImage(named: "CP1")
        let P1Button = UIButton()
        let P1Label = UILabel()
        P1Label.frame = CGRect(x: screenWidth/2-125, y: 90, width: 250, height: 30)
        P1Label.textAlignment = NSTextAlignment.center
        P1Label.text = "Tree plantation"
        P1Label.textColor = .white
        P1Label.font = UIFont.boldSystemFont(ofSize: 32)
        P1Button.frame = CGRect(x: 15, y: 10, width: screenWidth-30, height: 200)
        P1Button.setBackgroundImage(P1Image, for: UIControl.State.normal)
        P1Button.layer.cornerRadius = 15
        P1Button.clipsToBounds = true
        P1Button.addTarget(self, action:#selector(handlePress1), for: .touchUpInside)
        scrollView.addSubview(P1Button)
        scrollView.addSubview(P1Label)
        
        //MARK:- Project 2
        
        let P2Image = UIImage(named: "CP2")
        let P2Button = UIButton()
        let P2Label = UILabel()
        P2Label.frame = CGRect(x: screenWidth/2-250, y: 300, width: 500, height: 40)
        P2Label.textAlignment = NSTextAlignment.center
        P2Label.text = "Yoga in Greens"
        P2Label.textColor = .white
        P2Label.font = UIFont.boldSystemFont(ofSize: 32)
        P2Button.frame = CGRect(x: 15, y: 230, width: screenWidth-30, height: 200)
        P2Button.setBackgroundImage(P2Image, for: UIControl.State.normal)
        P2Button.layer.cornerRadius = 15
        P2Button.clipsToBounds = true
        P2Button.addTarget(self, action:#selector(handlePress2), for: .touchUpInside)
        scrollView.addSubview(P2Button)
        scrollView.addSubview(P2Label)
        
        //MARK:- Project 3
               
        let P3Image = UIImage(named: "CP3")
        let P3Button = UIButton()
        let P3Label = UILabel()
        P3Label.frame = CGRect(x: screenWidth/2-250, y: 520, width: 500, height: 40)
        P3Label.textAlignment = NSTextAlignment.center
        P3Label.text = "Recycled Water Show"
        P3Label.textColor = .white
        P3Label.font = UIFont.boldSystemFont(ofSize: 32)
        P3Button.frame = CGRect(x: 15, y: 450, width: screenWidth-30, height: 200)
        P3Button.setBackgroundImage(P3Image, for: UIControl.State.normal)
        P3Button.layer.cornerRadius = 15
        P3Button.clipsToBounds = true
        P3Button.addTarget(self, action:#selector(handlePress3), for: .touchUpInside)
        scrollView.addSubview(P3Button)
        scrollView.addSubview(P3Label)
        
        //MARK:- Project 4
               
        let P4Image = UIImage(named: "CP4")
        let P4Button = UIButton()
        let P4Label = UILabel()
        P4Label.frame = CGRect(x: screenWidth/2-250, y: 740, width: 500, height: 40)
        P4Label.textAlignment = NSTextAlignment.center
        P4Label.text = "Organic Pads"
        P4Label.textColor = .white
        P4Label.font = UIFont.boldSystemFont(ofSize: 32)
        P4Button.frame = CGRect(x: 15, y: 670, width: screenWidth-30, height: 200)
        P4Button.setBackgroundImage(P4Image, for: UIControl.State.normal)
        P4Button.layer.cornerRadius = 15
        P4Button.clipsToBounds = true
        P4Button.addTarget(self, action:#selector(handlePress4), for: .touchUpInside)
        scrollView.addSubview(P4Button)
        scrollView.addSubview(P4Label)
        
        //MARK:- Project 5
               
        let P5Image = UIImage(named: "CP5")
        let P5Button = UIButton()
        let P5Label = UILabel()
        P5Label.frame = CGRect(x: screenWidth/2-250, y: 960, width: 500, height: 40)
        P5Label.textAlignment = NSTextAlignment.center
        P5Label.text = "Awareness Skit"
        P5Label.textColor = .white
        P5Label.font = UIFont.boldSystemFont(ofSize: 32)
        P5Button.frame = CGRect(x: 15, y: 890, width: screenWidth-30, height: 200)
        P5Button.setBackgroundImage(P5Image, for: UIControl.State.normal)
        P5Button.layer.cornerRadius = 15
        P5Button.clipsToBounds = true
        P5Button.addTarget(self, action:#selector(handlePress5), for: .touchUpInside)
        scrollView.addSubview(P5Button)
        scrollView.addSubview(P5Label)
        
        //MARK:- Project 6
               
        let P6Image = UIImage(named: "CP6")
        let P6Button = UIButton()
        let P6Label = UILabel()
        P6Label.frame = CGRect(x: screenWidth/2-250, y: 1180, width: 500, height: 40)
        P6Label.textAlignment = NSTextAlignment.center
        P6Label.text = "Educating our Helpers"
        P6Label.textColor = .white
        P6Label.font = UIFont.boldSystemFont(ofSize: 32)
        P6Button.frame = CGRect(x: 15, y: 1110, width: screenWidth-30, height: 200)
        P6Button.setBackgroundImage(P6Image, for: UIControl.State.normal)
        P6Button.layer.cornerRadius = 15
        P6Button.clipsToBounds = true
        P6Button.addTarget(self, action:#selector(handlePress6), for: .touchUpInside)
        scrollView.addSubview(P6Button)
        scrollView.addSubview(P6Label)
        
        
    
    }
    
    //MARK:- Page Functions
    
    @objc func handlePress1() {
        let controller = UINavigationController(rootViewController: Project1())
        controller.modalPresentationStyle = UIModalPresentationStyle.overCurrentContext
        present(controller, animated:  true, completion: nil)
    }
    
    @objc func handlePress2() {
        let controller = UINavigationController(rootViewController: Project2())
        controller.modalPresentationStyle = UIModalPresentationStyle.overCurrentContext
        present(controller, animated:  true, completion: nil)
    }
    @objc func handlePress3() {
        let controller = UINavigationController(rootViewController: Project3())
        controller.modalPresentationStyle = UIModalPresentationStyle.overCurrentContext
        present(controller, animated:  true, completion: nil)
    }
    @objc func handlePress4() {
        let controller = UINavigationController(rootViewController: Project4())
        controller.modalPresentationStyle = UIModalPresentationStyle.overCurrentContext
        present(controller, animated:  true, completion: nil)
    }
    @objc func handlePress5() {
        let controller = UINavigationController(rootViewController: Project5())
        controller.modalPresentationStyle = UIModalPresentationStyle.overCurrentContext
        present(controller, animated:  true, completion: nil)
    }
    @objc func handlePress6() {
        let controller = UINavigationController(rootViewController: Project6())
        controller.modalPresentationStyle = UIModalPresentationStyle.overCurrentContext
        present(controller, animated:  true, completion: nil)
    }
    
    @objc func handleDismiss() {
        dismiss(animated: true, completion: nil)
    }
    
    @objc func doNothing(_ sender:UIButton!) {
        
    }
    
    //MARK:- Scroll View
    
    lazy var scrollView: UIScrollView = {
        let view = UIScrollView()
        view.translatesAutoresizingMaskIntoConstraints = false
        view.contentSize.height = 1300
        view.backgroundColor = .white
        return view
    }()
    
    func setupScrollView() {
        view.addSubview(scrollView)
        scrollView.topAnchor.constraint(equalTo: view.topAnchor).isActive = true
        scrollView.bottomAnchor.constraint(equalTo: view.bottomAnchor).isActive = true
        scrollView.leftAnchor.constraint(equalTo: view.leftAnchor).isActive = true
        scrollView.rightAnchor.constraint(equalTo: view.rightAnchor).isActive = true
    }
}
class Project1: UIViewController {

    //MARK:- viewDidLoad
    
    override func viewDidLoad() {
        super.viewDidLoad()
        setupView()
    }
    
    //MARK:- Page Setup
    
    func setupView() {
        
        let projImge1 = UIImage(named: "A1P")
        let projBut1 = UIButton()
        projBut1.frame = CGRect(x: 15, y: 110, width: screenWidth-30, height: 550)
        projBut1.setBackgroundImage(projImge1, for: UIControl.State.normal)
        projBut1.layer.cornerRadius = 15;
        projBut1.clipsToBounds = true
        self.view.addSubview(projBut1)
        
        let label4 = UILabel(frame: CGRect(x: 0, y: 0, width: screenWidth-40, height: 200))
        label4.center = CGPoint(x: screenWidth/2, y: 720)
        label4.text = " Residents of Vipul Greens rise together to make an impact on Earth Day. The EcoWarriors raised funds to donate and plant 101 saplings to reduce the effects of global warming. "
        label4.numberOfLines = 10
        label4.lineBreakMode = .byWordWrapping
        label4.textColor = .white
        label4.font = UIFont(name: "Helvetica", size: 16)
        label4.textAlignment = NSTextAlignment.center
        self.view.addSubview(label4)
        
        //MARK:- Navigation Bar
        self.navigationItem.title = "Tree Plantation"
        navigationController?.navigationBar.barTintColor = .mainBlue()
        navigationItem.leftBarButtonItem = UIBarButtonItem(image: #imageLiteral(resourceName: "Cross").withRenderingMode(.alwaysOriginal), style: .plain, target: self, action: #selector(handleDismiss))
        navigationController?.navigationBar.barStyle = .black
        view.backgroundColor = UIColor.black.withAlphaComponent(0.9)
        
        
    }
    
    //MARK:- Page Functions
    
    @objc func handleDismiss() {
        dismiss(animated: true, completion: nil)
    }
}

class Project2: UIViewController {

    //MARK:- viewDidLoad
    
    override func viewDidLoad() {
        super.viewDidLoad()
        setupView()
    }
    
    //MARK:- Page Setup
    
    func setupView() {
        
        let projImge1 = UIImage(named: "Achivment2")
        let projBut1 = UIButton()
        projBut1.frame = CGRect(x: 15, y: 110, width: screenWidth-30, height: 550)
        projBut1.setBackgroundImage(projImge1, for: UIControl.State.normal)
        projBut1.layer.cornerRadius = 15;
        projBut1.clipsToBounds = true
        self.view.addSubview(projBut1)
        
        let label4 = UILabel(frame: CGRect(x: 0, y: 0, width: screenWidth-40, height: 200))
        label4.center = CGPoint(x: screenWidth/2, y: 720)
        label4.text = "On International Yoga Day, EcoWarriors organized a morning yoga session for the residents of VG. This was done in the gardens of VG to bulid a stronger connect between the residents and mother nature. "
        label4.numberOfLines = 10
        label4.lineBreakMode = .byWordWrapping
        label4.textColor = .white
        label4.font = UIFont(name: "Helvetica", size: 16)
        label4.textAlignment = NSTextAlignment.center
        self.view.addSubview(label4)
        
        //MARK:- Navigation Bar
        self.navigationItem.title = "Yoga in Greens"
        navigationController?.navigationBar.barTintColor = .mainBlue()
        navigationItem.leftBarButtonItem = UIBarButtonItem(image: #imageLiteral(resourceName: "Cross").withRenderingMode(.alwaysOriginal), style: .plain, target: self, action: #selector(handleDismiss))
        navigationController?.navigationBar.barStyle = .black
        view.backgroundColor = UIColor.black.withAlphaComponent(0.9)
        
        
    }
    
    //MARK:- Page Functions
    
    @objc func handleDismiss() {
        dismiss(animated: true, completion: nil)
    }
}

class Project3: UIViewController {

    //MARK:- viewDidLoad
    
    override func viewDidLoad() {
        super.viewDidLoad()
        setupView()
    }
    
    //MARK:- Page Setup
    
    func setupView() {
        
        let projImge1 = UIImage(named: "Achivment3")
        let projBut1 = UIButton()
        projBut1.frame = CGRect(x: 15, y: 110, width: screenWidth-30, height: 550)
        projBut1.setBackgroundImage(projImge1, for: UIControl.State.normal)
        projBut1.layer.cornerRadius = 15;
        projBut1.clipsToBounds = true
        self.view.addSubview(projBut1)
        
        let label4 = UILabel(frame: CGRect(x: 0, y: 0, width: screenWidth-40, height: 200))
        label4.center = CGPoint(x: screenWidth/2, y: 725)
        label4.text = "The EcoWarrior team worked together with hydro department of VG to purify sewage water and display a light water and music show for the residents of VG"
        label4.numberOfLines = 10
        label4.lineBreakMode = .byWordWrapping
        label4.textColor = .white
        label4.font = UIFont(name: "Helvetica", size: 16)
        label4.textAlignment = NSTextAlignment.center
        self.view.addSubview(label4)
        
        //MARK:- Navigation Bar
        self.navigationItem.title = "Recycled Water Show"
        navigationController?.navigationBar.barTintColor = .mainBlue()
        navigationItem.leftBarButtonItem = UIBarButtonItem(image: #imageLiteral(resourceName: "Cross").withRenderingMode(.alwaysOriginal), style: .plain, target: self, action: #selector(handleDismiss))
        navigationController?.navigationBar.barStyle = .black
        view.backgroundColor = UIColor.black.withAlphaComponent(0.9)
        
        
    }
    
    //MARK:- Page Functions
    
    @objc func handleDismiss() {
        dismiss(animated: true, completion: nil)
    }
}

class Project4: UIViewController {

    //MARK:- viewDidLoad
    
    override func viewDidLoad() {
        super.viewDidLoad()
        setupView()
    }
    
    //MARK:- Page Setup
    
    func setupView() {
        
        let projImge1 = UIImage(named: "Achivment4")
        let projBut1 = UIButton()
        projBut1.frame = CGRect(x: 15, y: 110, width: screenWidth-30, height: 550)
        projBut1.setBackgroundImage(projImge1, for: UIControl.State.normal)
        projBut1.layer.cornerRadius = 15;
        projBut1.clipsToBounds = true
        self.view.addSubview(projBut1)
        
        let label4 = UILabel(frame: CGRect(x: 0, y: 0, width: screenWidth-40, height: 200))
        label4.center = CGPoint(x: screenWidth/2, y: 720)
        label4.text = "An organic pad company, Liqua came to VG to distribute and create awareness about the need to reduce the use of plastic and reccomend felmaes to use organic pads. "
        label4.numberOfLines = 10
        label4.lineBreakMode = .byWordWrapping
        label4.textColor = .white
        label4.font = UIFont(name: "Helvetica", size: 16)
        label4.textAlignment = NSTextAlignment.center
        self.view.addSubview(label4)
        
        //MARK:- Navigation Bar
        self.navigationItem.title = "Organic Pads"
        navigationController?.navigationBar.barTintColor = .mainBlue()
        navigationItem.leftBarButtonItem = UIBarButtonItem(image: #imageLiteral(resourceName: "Cross").withRenderingMode(.alwaysOriginal), style: .plain, target: self, action: #selector(handleDismiss))
        navigationController?.navigationBar.barStyle = .black
        view.backgroundColor = UIColor.black.withAlphaComponent(0.9)
        
        
    }
    
    //MARK:- Page Functions
    
    @objc func handleDismiss() {
        dismiss(animated: true, completion: nil)
    }
}

class Project5: UIViewController {

    //MARK:- viewDidLoad
    
    override func viewDidLoad() {
        super.viewDidLoad()
        setupView()
    }
    
    //MARK:- Page Setup
    
    func setupView() {
        
        let projImge1 = UIImage(named: "achivment5")
        let projBut1 = UIButton()
        projBut1.frame = CGRect(x: 15, y: 110, width: screenWidth-30, height: 550)
        projBut1.setBackgroundImage(projImge1, for: UIControl.State.normal)
        projBut1.layer.cornerRadius = 15;
        projBut1.clipsToBounds = true
        self.view.addSubview(projBut1)
        
        let label4 = UILabel(frame: CGRect(x: 0, y: 0, width: screenWidth-40, height: 200))
        label4.center = CGPoint(x: screenWidth/2, y: 720)
        label4.text = "The EcoWarriors team organized a skit competition on environmental awareness. There were over 40 participants.These skits created awareness and educated the residents of VG."
        label4.numberOfLines = 10
        label4.lineBreakMode = .byWordWrapping
        label4.textColor = .white
        label4.font = UIFont(name: "Helvetica", size: 16)
        label4.textAlignment = NSTextAlignment.center
        self.view.addSubview(label4)
        
        //MARK:- Navigation Bar
        self.navigationItem.title = "Awareness Skit"
        navigationController?.navigationBar.barTintColor = .mainBlue()
        navigationItem.leftBarButtonItem = UIBarButtonItem(image: #imageLiteral(resourceName: "Cross").withRenderingMode(.alwaysOriginal), style: .plain, target: self, action: #selector(handleDismiss))
        navigationController?.navigationBar.barStyle = .black
        view.backgroundColor = UIColor.black.withAlphaComponent(0.9)
        
        
    }
    
    //MARK:- Page Functions
    
    @objc func handleDismiss() {
        dismiss(animated: true, completion: nil)
    }
}

class Project6: UIViewController {

    //MARK:- viewDidLoad
    
    override func viewDidLoad() {
        super.viewDidLoad()
        setupView()
    }
    
    //MARK:- Page Setup
    
    func setupView() {
        
        let projImge1 = UIImage(named: "achivment6")
        let projBut1 = UIButton()
        projBut1.frame = CGRect(x: 15, y: 110, width: screenWidth-30, height: 550)
        projBut1.setBackgroundImage(projImge1, for: UIControl.State.normal)
        projBut1.layer.cornerRadius = 15;
        projBut1.clipsToBounds = true
        self.view.addSubview(projBut1)
        
        let label4 = UILabel(frame: CGRect(x: 0, y: 0, width: screenWidth-40, height: 200))
        label4.center = CGPoint(x: screenWidth/2, y: 720)
        label4.text = "The EcoWarriors team created awareness amongst  helpers of VG about the environment. They educated over 200 helpers about the the 3 R's and and gave them environmental tips.  "
        label4.numberOfLines = 10
        label4.lineBreakMode = .byWordWrapping
        label4.textColor = .white
        label4.font = UIFont(name: "Helvetica", size: 16)
        label4.textAlignment = NSTextAlignment.center
        self.view.addSubview(label4)
        
        //MARK:- Navigation Bar
        self.navigationItem.title = "Educating our helpers"
        navigationController?.navigationBar.barTintColor = .mainBlue()
        navigationItem.leftBarButtonItem = UIBarButtonItem(image: #imageLiteral(resourceName: "Cross").withRenderingMode(.alwaysOriginal), style: .plain, target: self, action: #selector(handleDismiss))
        navigationController?.navigationBar.barStyle = .black
        view.backgroundColor = UIColor.black.withAlphaComponent(0.9)
        
        
    }
    
    //MARK:- Page Functions
    
    @objc func handleDismiss() {
        dismiss(animated: true, completion: nil)
    }
}
